#|____________________________________________________________________
 |
 |  message2.lsp 
 |  this file has code that implements help panels and help window chains
 |     with code for HELP-TOPICS-PANEL, WELCOME-TOPICS-PANEL, and for
 |     MENU-ITEM-HELP-CONTROL-PANEL
 |
 |  Copyright (c) 2001 by Forrest W. Young
 |  All rights reserved 
 |____________________________________________________________________
 |#

(defun menu-item-help+ ()
  (help "The Menu Item Help item of the Help Menu displays a help topics panel that gives you access to the help information for every menu item on the desktop's menu bar.")
  (menu-item-help))


(defun develcome-message ()
  (file-to-window  (strcat *help-dir-name* "develcome.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun personal-message ()
  (file-to-window  (strcat *help-dir-name* "personal.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun appdevel-message ()
  (file-to-window  (strcat *help-dir-name* "appdevel.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun sysdevel-message ()
  (file-to-window  (strcat *help-dir-name* "sysdevel.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun about-editing-data ()
  (file-to-window  (strcat *help-dir-name* "about-ed.hlp") 
                   (strcat "About Editing Data")
                   (send *vista* :help-window-object) t nil))

(defun no-help.hlp ()
  (read-help "nohelp.hlp" "Help: Unavailable."))

(defun not-yet-written ()
  (help  "We are sorry, but this part of the help and documentation system is not available.")
  (top-level nil))

(defun help-not-available ()
  (help  "We are sorry, but help on this topic is not yet available."))

(defun not-now-working ()
  (help "We are sorry, but this example is not available."))


(defun no-message ()
  (help  ".  "))

(defun plothelp-summary ()
  (help (format nil "~%PLOTS FOR VISUALIZING DATA:~%All of the plots available for visualizing data are listed in this subtopic. A specific plot may have additional features not given here. Use the plots help button for that informaton.~2%PLOTS FOR VISUALIZING MODELS:~%There are numerous additional specialized plots for visualizing models that are not listed. You can get help for those by generating the plot and then using its help button.")))

(defun not-yet-in-help-panel ()
  (help (format nil "~%The help for this type of plot has not yet been brought into the help topics panel. You can get help for this type of plot by generating an instance of the plot and then using its help button.")))

(defun dot-plot-help ()
    (send boxplot-proto :plot-help :type "dot"))

(defun box-plot-help ()
    (send boxplot-proto :plot-help :type "box"))

(defun diamond-plot-help ()
    (send boxplot-proto :plot-help :type "diamond"))

(defun frequency-distribution-help ()
  (read-help "freqplot.hlp" "Help for Frequency Distribution Plot"))

(defun histogram-help ()
  (read-help "histogram.hlp" "Help for Histogram"))

(defun quantile-plot-help ()
  (send quantile-plot-proto :plot-help :type "qplot"))

(defun quantile-quantile-plot-help ()
  (send quantile-quantile-plot-proto :plot-help))

(defun normal-probability-plot-help ()
  (send quantile-plot-proto :plot-help :type "npplot"))

(defun bar-graph-help ()
  (send mosaic-proto :plot-help))

(defun mosaic-plot-help ()
  (send mosaic-proto :plot-help))

(defun scatterplot-help ()
  (read-help "scatplot.hlp" "Help for Scatterplot"))

(defun spinplot-help ()
  (read-help "spinplot.hlp" "Help for Spinning Plot"))

(defun scatmat-help ()
  (read-help "scatmat.hlp" "Help for Scatterplot Matrix"))

(defun tourplot-help ()
  (read-help "tourplot.hlp" "Help for Tour Plot"))

(defun installing-vista ()
  (read-help "installi.hlp" "Help with Installation"))

(defun menu-item-summary (menu)
  (help (format nil "This topic presents you with the help information for the items of the ~a Menu. Choose an item to see its help." menu)))

(defun about-the-menus ()
  (menu-help-without-item-help)) 

(defun popup-desktop-menu-help ()
  (pop-up-menus))

(defun pop-up-menus ()
  (file-to-window  (strcat *help-dir-name* "pop-up-m.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun about-filetypes ()
  (file-to-window  (strcat *help-dir-name* "filetype.hlp") 
                   (strcat "Help for ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


;(defun get-menu-item-help (menu item)
;   (let ((show-help (send *vista* :show-help)))
;     (send *vista* :show-help t)
;     (send item :do-action)
;     (send *vista* :show-help show-help)))

(defun get-menu-item-help (item)
  (send *vista* :show-help t)
  (send item :do-action)
  (send *vista* :show-help nil))

(defun make-menu-item-help-function-list (menu)
  (append (list `(menu-item-summary ,(send menu :title)))
           (remove nil
                   (mapcar #'(lambda (item) 
                               (if (equal "-" (send item :title) )
                                   nil
                                   `(get-menu-item-help ,item)))
                           (send menu :items)))))

(defun get-menu-item-titles (menu)
  (append (list (strcat "The " (send menu :title) " Menu"))
           (remove nil 
                   (mapcar #'(lambda (item) 
                               (if (equal "-" (send item :title) )
                                   nil
                                   (send item :title)))
                   (send menu :items)))))



(defun get-analysis-menu-help (item-title)
  (let ((show-help (send *vista* :show-help))
        )
    (mapcar #'(lambda (item)
                (when (equal (send item :title) item-title)
                      (send *vista* :show-help t)
                      (send item :do-action)
                      (send *vista* :show-help show-help)
                      ))
            (send *analyze-menu* :items))))

(defun window-menu-help ()
  (send *vista* :file-to-help-window  
        (strcat *help-path* "window.hlp") "Windows Menu Help" *help-window* )
  )

(defun desktop-menu-help ()
  (send *vista* :file-to-help-window  
        (strcat *help-path* "desktophelp.hlp") "DeskTop Menu Help" *help-window* )
  )

(defun writing-plots ()
  (send *vista* :file-to-help-window
        (strcat *help-path* "plots.hlp") "Plots Help" *help-window*))

(defun writing-applets ()
  (send *vista* :file-to-help-window
        (strcat *help-path* "applets.hlp") "Applets Help" *help-window*))

(defun preferences-dialog-help ()
(send *vista* :file-to-help-window  (strcat *help-path* "preferences.hlp") "Preferences Dialog Help" *help-window* :fit t))

(defun options-menu-help ()
  (send *vista* :file-to-help-window  
        (strcat *help-path* "options.hlp") "Options Menu Help" *help-window* )
  )

(defun help-menu-help ()
  (send *vista* :file-to-help-window  
        (strcat *help-path* "helpmenuhelp.hlp") "Help Menu Help" *help-window* )
  )

(defun plot-menu-summary ( )
  (send *vista* :file-to-help-window
        (strcat *help-path* "plot-ove.hlp") "Plot Menu Summary" *help-window*)) 


(defun cumulati-help ( )
  (send *vista* :file-to-help-window
        (strcat *help-path* "cumulati.hlp") "Cumulative Plot Help" *help-window*)) 


(defun comparis-help ( )
  (send *vista* :file-to-help-window
        (strcat *help-path* "comparis.hlp") "Comparison Plot Help" *help-window*)) 

(defun writing-datacode ( )
  (send *vista* :file-to-help-window
        (strcat *help-path* "datacode.hlp") "Help for Writing Datacode" *help-window*)) 

(defun demos-data-message ())
(defun do-uni  ())
(defun do-bi ())
(defun do-multi ())
(defun do-tour ())
(defun do-crstab ())
(defun do-class ())
(defun do-freq ())
(defun do-cat ())
(defun demos-message ())
(defun demo-simulate ())
(defun demo-univar ())
(defun demo-anova ())
(defun demo-reg-influence ())
(defun demo-reg-range ())
(defun demo-missing ())
(defun demo-boxcox ())
(defun demo-princomp ())
(defun demo-lda ())
(defun using-vista ())
(setf *help-control-panel* nil)
(setf *help-progress* 0)

(defun topic-list (&rest args)
  (list
   "Getting Help"
   "ViSta OnLine"
   "Getting Started"
   "Using Excel"
   "Using the DeskTop"
   "Using the Menus"
   "Entering Data"
   "Managing Data"
   "Graphing Data"
   ;"Seeing Data"
   "Analyzing Data"
   "Modeling Data"
   "Enhancing ViSta"
  ; "The Data Menu" "The Transform Menu" "The Analyze Menu" "The Model Menu" 
  ; "Other DeskTop Menus"
   ))




(defun subtopics-list (&rest args)
  (list
;getting help
   (list "HELP!" "Help Resources" "Help OnLine")
;vista online
  (list "ViSta OnLine" "Register With Us" "Join the NewsGroup") 
;getting started
   (list "Getting Started" "Installing ViSta" "About ViSta" )
;excel and vista
   (list "Excel and ViSta" "From Excel to ViSta" "From ViSta to Excel" 
         "Notes about Using Excel" "Changing Excel's ViSta Menu")
;using the desktop
   (list "The DeskTop" "The Menu Bar" "Pop-Up Menus"
         "The ToolBar" ;"DeskTop Options" 
         "The WorkMap" "The DataSheet" "The Selector" "The Listener" )
;using the menus
   (list "The Menu Bar" "Pop-Up Menus" "Menu Item Help")
;entering data
   (list "Editing Data" "ViSta's DataSheet" "Excel SpreadSheets" "SAS Datasets"
         "Importing Data" "Simulating Data" "Writing DataCode")
;managing data
   (list "Managing Data" "Variable and Data Types" 
         "Manipulating Variables" "Using ViVa" 
         "Making Variables" "Making Data")
;graphing data
   (list "Graphing Your Data" "Plot Menu Overview" "The Box, Diamond and Dot Plots" 
         "HistoGram and Distribution Plots" 
         "Cumulative Plot" 
         "Comparison Plot" 
         "Mosaic Plot and Bar Chart" 
         "Scatter Plot" "Spinning Points Plot" 
         "Scatter Matrix" "Orbiting Points Plot")
  ; (list "Seeing Data"
  ;       "Univariate SpreadPlot" "Bivariate SpreadPlot" 
  ;       "Multivariate SpreadPlot" 
  ;       "Categorical SpreadPlot" "CrossTabs  SpreadPlot" 
  ;       "Classification  SpreadPlot"
  ;       "Frequency Data SpreadPlot")
   (get-menu-item-titles *analyze-menu*)
   (get-menu-item-titles *model-menu*)
;fwy added writing-updates 09-18-02
   (list "Enhancing ViSta" "Application Development" "System Development" 
         "Writing Applets" "Writing Plots" "Writing Spreadplots" "Writing Plugins" "Writing Updates" "About DataTypes" "About FileTypes")
   
   ))

(defun about-version-7 () (help "Not yet written"))
(defun new-features-7 () (help "Not Yet Written"))
(defun the-file-menu () (help "Not Yet Written"))

(defun actions-list (&optional (*full* t))
  (list
;getting help
   (LIST '(HELP!) '(welcome5-message) '(online-help))
;vista online
   (list '(vista-online) '(online-register) '(online-newsgroup))
;getting started
   (list '(getting-started) '(INSTALLING-VISTA) '(about-version-6 )  ) 
;excel and vista
   (list '(using-excel-and-vista) '(from-excel-to-vista) '(from-vista-to-excel)
         '(notes-about-using-excel) '(changing-excels-vista-menu))
   (list '(desktop-help)   
         '(about-the-menus) '(pop-up-menus) 
         '(toolbar-help) ; '(desktop-options-help) 
         '(workmap-help)  '(datasheet-help) '(selector-help) '(listener-help))
;using the menus
   (list '(about-the-menus) '(pop-up-menus) '(menu-item-help))
;entering data
   (list '(about-editing-data) '(using-the-datasheet) '(from-excel-to-vista) '(SAS2ViSta)
         '(importing-data) '(simulating-data) '(writing-datacode))
   (list '(about-the-data-system) '(vartypes-datatypes) '(manipulating-variables)
         '(the-variable-language) '(the-variable-maker) '(the-data-maker))
;graphing data
   (list '(menu-item-summary "Graphics") '(plot-menu-summary) '(box-plot-help) 
         '(help-not-available) ;'(histofreq-help)
         '(cumulati-help)
         '(comparis-help) 
         '(mosaic-plot-help)
         '(scatterplot-help) '(spinplot-help) '(scatmat-help) '(tourplot-help))
  ; (list '(about-the-spreadplots)  '(univariate-SpreadPlot) 
  ;       '(bivariate-SpreadPlot)   '(multivariate-spreadPlot)
  ;       '(categorical-spreadplot)
  ;       '(CrossTabs-SpreadPlot)   '(Classification-SpreadPlot) 
  ;                           '(frequency-spreadplot))

   (make-menu-item-help-function-list *analyze-menu*)
   (make-menu-item-help-function-list *model-menu*)
;fwy added writing-updates 09-18-02
   (list '(enhancing-vista) '(appdevel-message) '(sysdevel-message) '(writing-applets)
         '(writing-plots) '(writing-spreadplots) '(writing-plugins) '(writing-updates) '(data-type-help) '(about-filetypes))
   ))


(defun enhancing-vista ()
  (help (format nil "~%ENHANCING ViSta:~%ViSta is an OPEN software system. That means that its code is OPEN to those who wish to enhance the system. The items in this help topic are designed to help you understand how to take advantage of this aspect of ViSta.")))


#|__ help-panel ___________________________|#
  
(defun help-control-panel (&optional (initial-topic nil initial-topic?) 
                                     (initial-subtopic nil initial-subtopic?) 
                                     (initial-action nil initial-action?)
                                &key 
                                     (choice-to-show-vista-at-close nil)
                                     (choice-to-show-dialog-again-at-startup t))
"Args - &optional (initial-topic nil) (initial-subtopic nil) (initial-action nil)  &key (choice-to-show-vista-at-close nil) (choice-to-show-again-at-startup nil)
Presents help panel. If INITIAL-TOPIC is nil, no topic or subtopic is selected. If INITIAL-TOPIC  and INITIAL-SUBTOPIC are both a non-negative integer in the appropriate range, then the specified INITIAL-TOPIC and INITIAL-SUBTOPIC is intially selected. The initial subtopic is shown if INITIAL-ACTION is T, and not shown if NIL. Optionally presents one or two choice boxes depending if one or the other or both of the CHOICE-TO- arguments are true, and, if the choice box is checked when the dialog is closed, carries out the indicated choice(s)"

;(PRINT (LIST "help-control-panel "))

  (if *help-control-panel* 
   (send *help-control-panel* 
         :show-window initial-topic initial-subtopic
         :do-action initial-action)
   (let* ((datademo (not (not (load (strcat *demos-path* "datademo.lsp") 
                                    :if-does-not-exist nil))))
          (analdemo t)
          (multidemo (not (not (load (strcat *demos-path* "mvardemo.lsp")
                                     :if-does-not-exist nil))))
          (topics (topic-list))
          (subtopics (subtopics-list))
          (actions (actions-list))
          (dialog
           (double-list-dialog 
            topics subtopics actions
            :initial (cond
                       (initial-action? (list initial-topic initial-subtopic initial-action))
                       (initial-subtopic? (list initial-topic initial-subtopic))
                       (initial-topic? (list initial-topic))
                       (t nil))
            :max-list-length-shown 24 
            :first t
            :title "Help Topics Panel"
            :location (effective-screen-size)
            :choice-to-show-vista-at-close 
                 choice-to-show-vista-at-close
            :choice-to-show-dialog-again-at-startup 
                 (list choice-to-show-dialog-again-at-startup 
                       (send *vista* :show-first-help))
            )))
     (defmeth dialog :show-again ()
       (send *vista* :show-first-help))   
     (defmeth dialog :dont-show-again ()
      (send *vista* :show-welcome (send self :toggle-value)))
     (setf *help-control-panel* dialog)
     (apply #'send dialog :location 
            (- (effective-screen-size) (send dialog :size) (list 4 4)))
     (send *vista* :show-first-help (send dialog :toggle2-value))
     (defmeth dialog :close ()
       (call-next-method)
       (send *vista* :show-first-help (send dialog :toggle2-value)))
     dialog)))
      


(defun window-chain (&rest args) (apply) '(window-chain-messages2 args))

(defun window-chain-messages2 (function-list 
                               &optional (non-window-last-function nil) 
                               (window-click t)
                               (close-menu t)
                               (topic-number nil)
                               (subtopic-number nil))
"Args: Window-Function-List &Optional (Non-Window-Last-Function nil) (window-click t) (close-menu t) (topic-number nil) (subtopic-number nil) 
Presents a chain of windows, one at a time, each one appearing after the previous one closes. In addition to the usual methods, each window can be closed by clicking anywhere on the window unless WINDOW-CLICK is NIL. When the close box is used, a menu of choices for navigating the chain appears, unless CLOSE-MENU is NIL. Use Non-Window-Last-Function when last link of the chain is not a window."
  (let ((w nil)
        (n (length function-list)))
    (defmeth *desktop-container* :close ()
      (send w :remove)
      (vista-exit))
    (send *vista* :add-slot 'window-chain-functions)
    (run-window-chain function-list w 0 n non-window-last-function window-click
                      topic-number subtopic-number close-menu) 
    (defmeth *desktop-container* :close ()
      (vista-exit))))

(defun run-window-chain (function-list w i n f c top subtop close-menu)
  (send *vista* :slot-value 'window-chain-functions function-list)
  (setf w (funcall (select function-list i)))
  (unless (equal "Next" (send (first (send (send w :menu) :items)) :title))
          (send w :window-chain-menu))
  (send w :show-window)
  (send w :top-most t)
  (send w :title 
        (strcat (send w :title) 
                (format nil " (~d of ~d)" i n)))  
  (defmeth w :do-click (x y m1 m2) ;m2 is right button
    (cond
      ((and m1 m2) (send w :remove))
      (m1 (setf i (1- i)) (if (< i 0) (setf i 0))
          (run-window-chain function-list w i n f c))
      (m2 (setf menu-item-number (send (send w :menu) :popup x y w)))
      ((< i n) (setf i (1+ i))(run-window-chain function-list w i n f c))))

  (if close-menu
      (defmeth w :close () (send self :do-click 100 100 nil t))
      (defmeth w :close () (call-next-method)))
  w)
  
  
(defmeth display-window-proto2 :short-window-chain-menu ()
  (let* ((menu (send menu-proto :new "  ")))
    (send menu :append-items
          (send menu-item-proto :new "Next"
                :action #'(lambda () (send *help-window* :do-click 100 100 nil nil)))
          (send menu-item-proto :new "Back"
                :action #'(lambda () (send *help-window* :do-click 100 100 t nil)))
          (send menu-item-proto :new "Exit"
                :action #'(lambda () (send *help-window* :remove))))))

  
(defmeth display-window-proto2 :window-chain-menu ()
  (let* ((menu (send self :menu))
         (items (send menu :items))
         (nitems (length items))
         )
    (when (> nitems 0) (apply) '(send menu :delete-items items))
    (send menu :append-items
            (send menu-item-proto :new "Next"
                  :action #'(lambda () (send *help-window* :do-click 100 100 nil nil)))
          (send menu-item-proto :new "Back"
                :action #'(lambda () (send *help-window* :do-click 100 100 t nil)))
          (send menu-item-proto :new "Exit"
                :action #'(lambda () (send *help-window* :remove)))
          (send dash-item-proto :new))
    (apply #'send menu :append-items items)))





#|__ welcome-panel ___________________________|#
  
(defun bio-fwy ()
  (file-to-window  (strcat *help-dir-name* "fwy.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun bio-pvm ()
  (file-to-window  (strcat *help-dir-name* "bio-pvm.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun bio-gabi ()
  (file-to-window  (strcat *help-dir-name* "bio-gabi.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

       
(defun welcome-to-vista () (welcome-control-panel))
(defun welcome-to-vista- () (welcome-control-panel 0 0 nil))

(setf *welcome-control-panel* nil)

(defun WELCOME-control-panel (&optional (initial-topic nil) (initial-subtopic nil) 
                                     (initial-action nil)
                                         &key
                                     (choice-to-show-vista-at-close nil)
                                     (choice-to-show-dialog-again-at-startup t))
"Args - &optional (initial-topic nil) (initial-subtopic nil) (show-message nil)
Present help panel with topic INITIAL-TOPIC and subtopic INITIAL-SUBTOPIC selected and their action has occured. If INITIAL-TOPIC is nil, no topic or subtopic is selected. If INITIAL-TOPIC  and INITIAL-SUBTOPIC are both a non-negative integer in the appropriate range, then the specified INITIAL-TOPIC and INITIAL-SUBTOPIC is intially selected. The initial subtopic is shown unless show is nil."
  (if *welcome-control-panel* 
   (send *welcome-control-panel* 
         :show-window initial-topic initial-subtopic
         :do-action initial-action)
   (let* ((welcome-topics (welcome-topic-list))
          (welcome-subtopics (welcome-subtopics-list))
          (welcome-actions (welcome-actions-list))
          (dialog 
           (double-list-dialog welcome-topics welcome-subtopics welcome-actions
                               :initial (list initial-topic initial-subtopic initial-action)
                               :max-list-length-shown 10
                               :first t
                               :title "Welcome Topics Panel"
                               :location (effective-screen-size)
                               :choice-to-show-vista-at-close nil
                               :choice-to-show-dialog-again-at-startup 
                                     (list choice-to-show-dialog-again-at-startup
                                           (send *vista* :show-welcome))
                               :close nil))
          )
     (setf *welcome-control-panel* dialog)
     (send dialog :location 
            (first  (- (effective-screen-size) 
                      (send dialog :size) 
                      (list 4 4))) 
            (second (floor (/ (- (effective-screen-size) 
                                 (send dialog :size)) 4))))
     (defmeth dialog :close () 
       (setf *welcome-control-panel* nil)
       (when *help-window* (send *help-window* :close))
       (call-next-method))
     
     (defmeth dialog :show-again ()
       (send *vista* :show-welcome t))
     (defmeth dialog :dont-show-again ()
      (send *vista* :show-welcome (send self :toggle-value)))
     dialog)))

      

(defun WELCOME-topic-list (&rest args)
  (remove 'nil (list 
                (if *devel-mode* "WELCOME Developer!")
                (if *devel-mode* "WELCOME User!" "WELCOME!     ")
                "About ViSta   ")))


(defun WELCOME-subtopics-list (&rest args)
  (remove 'nil (list 
                (if *devel-mode* (list "WELCOME Developer!" "Developer Features"
                                       "Application Development" "System Development"))
                (list "WELCOME!" "ViSta Preview")
                (list "Contacting Us" "Copyrights" "Seeing and Insight" 
                      "Acknowledgments" "About Forrest Young" "About Pedro Valero" "About Gabriel Molina"))))
         


(defun WELCOME-actions-list (&optional (*full* t))
  (remove 'nil (list 
                (if *devel-mode* (list '(develcome-message) '(welcome-developer-message)
                                       '(appdevel-message) '(sysdevel-message)))
                (list '(WELCOME-message) '(about-version-6 ) ) 
                (list  '(title-cinerama) '(copyright-cinerama) 
                       '(poem-cinerama) '(acknowledgements-cinerama) '(fwy-cinerama)
                       '(pedro-cinerama) '(gabi-cinerama))
                )))





#|__ menu-item-help-panel ___________________________|#


(defun cut-item ()
  (file-to-window  (strcat *help-dir-name* "cut.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun copy-item ()
  (file-to-window  (strcat *help-dir-name* "copy.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))
(defun paste-item ()
  (file-to-window  (strcat *help-dir-name* "paste.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))
(defun clear-item ()
  (file-to-window  (strcat *help-dir-name* "clear.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))
(defun copy-paste-item ()
  (file-to-window  (strcat *help-dir-name* "copy-pas.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))
(defun about-the-edit-menu ()
  (file-to-window  (strcat *help-dir-name* "edit-men.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(setf *EXPLODED-DESKTOP* nil)
(setf *DESKTOP-MENUBAR-MENU-ITEMS* nil)
(setf *EXPLODED-DESKTOP-MENUBAR-MENU-ITEMS* nil)
(setf *exploded-desktop-menu* nil)
(setf *unexploded-seven-values* *seven-values*)
(setf *MENU-ITEM-HELP-CONTROL-PANEL* nil)

(defun menu-item-help () (menu-item-help-control-panel))

(defun menu-item-topic-list (&rest args)
  (list  "About The Menus" "The File Menu" "The Edit Menu" "The Data Menu" 
;"The Plots Menu" "The Views Menu" 
"The Transform Menu" "The Analyze Menu" "The Model Menu" "The Options Menu" "The Help Menu" "The DeskTop Menu" "The Window Menu"))

(defun menu-item-subtopic-list (&rest args)
  (list
   (list "The Menu Bar" "Pop-Up Menus")
   (get-menu-item-titles *vista-file-menu*)
   (list "The Edit Menu" "Cut" "Copy" "Paste" "Clear" "Copy-Paste")
   (get-menu-item-titles *data-menu*)
  ; (get-menu-item-titles *plots-menu*)
  ; (get-menu-item-titles *views-menu*)
   (get-menu-item-titles *trans-menu*)
   (get-menu-item-titles *analyze-menu*)
   (get-menu-item-titles *model-menu*)
   (get-menu-item-titles *command-menu*)
   (list "The Help Menu")
   (list "The DeskTop Menu")
   (list "The Window Menu")))

(defun menu-item-action-list (&rest args)
  (list
   (list '(about-the-menus) '(pop-up-menus))
   (make-menu-item-help-function-list *vista-file-menu*)
   (list '(about-the-edit-menu) '(cut-item) '(copy-item) 
         '(paste-item) '(clear-item) '(copy-paste-item))
   (make-menu-item-help-function-list *data-menu*)
  ; (make-menu-item-help-function-list *plots-menu*)
  ; (make-menu-item-help-function-list *views-menu*)
   (make-menu-item-help-function-list *trans-menu*)
   (make-menu-item-help-function-list *analyze-menu*)
   (make-menu-item-help-function-list *model-menu*)
   (make-menu-item-help-function-list *command-menu*)
   (list '(help-menu-help))
   (list '(desktop-menu-help)) 
   (list '(window-menu-help))
   ))

(defun menu-item-help-control-panel (&optional (initial-topic 0) (initial-subtopic nil) 
                                     (initial-action nil))
"Args - &optional (initial-topic nil) (initial-subtopic nil) (initial-action nil)
Presents help panel. The INITIAL-TOPIC and subtopic INITIAL-SUBTOPIC are selected and their action occurs if these arguments are T. If INITIAL-TOPIC is nil, no topic or subtopic is selected. If INITIAL-TOPIC  and INITIAL-SUBTOPIC are both a non-negative integer in the appropriate range, then the specified INITIAL-TOPIC and INITIAL-SUBTOPIC is intially selected. The initial subtopic is shown if INITIAL-ACTION is T."
  (if *menu-item-help-control-panel* 
   (send *menu-item-help-control-panel* 
         :show-window initial-topic initial-subtopic
         :do-action initial-action)
   (let* ((topics (menu-item-topic-list))
          (subtopics (menu-item-subtopic-list))
          (actions (menu-item-action-list))
          (dialog
           (double-list-dialog topics subtopics actions
                               :initial (list initial-topic initial-subtopic initial-action)
                               :max-list-length-shown 30 
                               :first t
                               :title "Menu Item Help Panel"
                               :location (effective-screen-size)
                               :close nil))
          )
     (setf *menu-item-help-control-panel* dialog)
     (send dialog :size 340 201)
     (apply #'send dialog :location 
            (- (effective-screen-size) 
               (send dialog :size) 
               (list 24 24)))
     (defmeth dialog :close () 
       (call-next-method)
       (setf *menu-item-help-control-panel* nil))
     (send dialog :show-window initial-topic initial-subtopic 
           :do-action initial-action)
     dialog)))
      